<?php
include('includes/functions.php');
$table_name = "user";

$log_check = $db->select($table_name, '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if (!empty($loggedinuser) && isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
    header("Location: main.php");
    exit;
}

$data = ['id' => '1','username' => 'admin','password' => 'admin',];
$db->insertIfEmpty($table_name, $data);

$error_message = "";
if (isset($_POST["login"])){
    $username = $_POST["username"];
    $userData = $db->select($table_name, '*', 'username = :username', '', [':username' => $username]);
    if ($userData) {
        $storedPassword = $userData[0]['password'];
        $enteredPassword = $_POST["password"];
        if ($enteredPassword == $storedPassword) {
            session_regenerate_id();
            $_SESSION['loggedin'] = TRUE;
            $_SESSION['name'] = $_POST['username'];
            if ($_POST['username'] == 'admin'){
                header('Location: user.php');
                exit;
            }else{
                header('Location: main.php');
                exit;
            }
        }else{
            $error_message = "Incorrect password. Please try again.";
        }
    }else{
        $error_message = "Username not found. Please check your credentials.";
    }
    $db->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SmartersPro2025</title>
    <link rel="icon" type="image/x-icon" href="./img/favicon.ico">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #8A2BE2;
            --primary-dark: #5D3FD3;
            --primary-light: #9370DB;
            --dark-color: #0f0f13;
            --dark-color-secondary: #161622;
            --light-color: #f5f5f5;
            --grey-color: #9ca3af;
            --error-color: #ef4444;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Montserrat', sans-serif;
        }

        body {
            min-height: 100vh;
            background-color: var(--dark-color);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }

        /* Background TV effect */
        .tv-background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(rgba(15, 15, 19, 0.8), rgba(15, 15, 19, 0.95)), 
                        url('https://images.unsplash.com/photo-1522869635100-9f4c5e86aa37?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1170&q=80');
            background-size: cover;
            background-position: center;
            z-index: -1;
        }

        .tv-lines {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(rgba(0, 0, 0, 0), rgba(0, 0, 0, 0));
            opacity: 0.03;
            z-index: -1;
            pointer-events: none;
            background-size: 100% 2px;
            background-image: linear-gradient(0deg, transparent 0%, rgba(138, 43, 226, 0.2) 2%, rgba(138, 43, 226, 0.8) 3%, rgba(138, 43, 226, 0.2) 3%, transparent 100%);
            animation: scan 7.5s linear infinite;
        }

        @keyframes scan {
            0% { background-position: 0 -100vh; }
            35%, 100% { background-position: 0 100vh; }
        }

        .login-container {
            width: 90%;
            max-width: 400px;
            background-color: rgba(22, 22, 34, 0.9);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            padding: 40px 30px;
            box-shadow: 0 15px 25px rgba(0, 0, 0, 0.5);
            color: white;
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Glowing border effect */
        .login-container::before {
            content: '';
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            background: linear-gradient(45deg, var(--primary-color), transparent, var(--primary-light));
            z-index: -1;
            border-radius: 16px;
            animation: glowing 20s linear infinite;
            opacity: 0.5;
        }

        @keyframes glowing {
            0% { background-position: 0 0; }
            50% { background-position: 400% 0; }
            100% { background-position: 0 0; }
        }

        h1 {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 5px;
            color: white;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .subtitle {
            font-size: 14px;
            color: #9ca3af;
            margin-bottom: 25px;
            text-align: center;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .form-control {
            height: 50px;
            padding: 10px 15px;
            padding-left: 45px;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            font-size: 15px;
            color: white;
            width: 100%;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            background-color: rgba(255, 255, 255, 0.08);
            box-shadow: 0 0 0 2px rgba(138, 43, 226, 0.3);
            outline: none;
        }

        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.3);
        }

        .form-icon {
            position: absolute;
            left: 16px;
            top: 16px;
            color: var(--primary-light);
            font-size: 18px;
        }

        .btn-login {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: #fff;
            border: none;
            height: 50px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            letter-spacing: 1px;
            cursor: pointer;
            transition: all 0.3s;
            width: 100%;
            text-transform: uppercase;
            margin-top: 10px;
            position: relative;
            overflow: hidden;
            z-index: 1;
        }

        .btn-login:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: all 0.5s;
            z-index: -1;
        }

        .btn-login:hover:before {
            left: 100%;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 15px rgba(138, 43, 226, 0.3);
        }

        .error-message {
            background-color: rgba(239, 68, 68, 0.15);
            color: #f87171;
            padding: 12px;
            border-radius: 8px;
            font-size: 14px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            border-left: 3px solid var(--error-color);
        }

        .error-message i {
            margin-right: 10px;
            font-size: 16px;
            color: var(--error-color);
        }

        .footer-text {
            text-align: center;
            font-size: 12px;
            color: rgba(255, 255, 255, 0.3);
            margin-top: 30px;
        }

        .footer-text a {
            color: var(--primary-light);
            text-decoration: none;
            transition: all 0.3s;
        }

        .footer-text a:hover {
            color: white;
            text-decoration: underline;
        }

        /* Visual equalizer animation at the bottom */
        .equalizer {
            height: 10px;
            width: 100%;
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 3px;
        }

        .bar {
            background: var(--primary-color);
            height: 100%;
            width: 8px;
            border-radius: 10px;
            animation: equalize 1.5s infinite ease-in-out;
        }

        .bar:nth-child(1) { animation-delay: 0.0s; }
        .bar:nth-child(2) { animation-delay: 0.1s; }
        .bar:nth-child(3) { animation-delay: 0.2s; }
        .bar:nth-child(4) { animation-delay: 0.3s; }
        .bar:nth-child(5) { animation-delay: 0.4s; }
        .bar:nth-child(6) { animation-delay: 0.5s; }
        .bar:nth-child(7) { animation-delay: 0.6s; }
        .bar:nth-child(8) { animation-delay: 0.7s; }

        @keyframes equalize {
            0%, 100% { transform: scaleY(0.3); }
            50% { transform: scaleY(1); }
        }
    </style>
</head>

<body>
    <div class="tv-background"></div>
    <div class="tv-lines"></div>

    <div class="login-container">
        <h1>SmartersPro2025</h1>
        <p class="subtitle">Max Rebrands Rebrand</p>

        <?php if (!empty($error_message)): ?>
        <div class="error-message">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo htmlspecialchars($error_message); ?>
        </div>
        <?php endif; ?>

        <form method="post">
            <div class="form-group">
                <i class="fas fa-user form-icon"></i>
                <input type="text" class="form-control" placeholder="Usuario" name="username" required autofocus>
            </div>
            
            <div class="form-group">
                <i class="fas fa-lock form-icon"></i>
                <input type="password" class="form-control" placeholder="Contraseña" name="password" required>
            </div>
            
            <button type="submit" class="btn-login" name="login">
                Ingresar
            </button>
        </form>

        <div class="equalizer">
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
        </div>
        
        <p class="footer-text">
            <a href="https://t.me/" target="_blank">Max Rebrands Panels</a>
        </p>
    </div>

    <script src="https://code.jquery.com/jquery-3.3.1.js"></script>
</body>

</html>